# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.compute import ComputeManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestComputeManagementDiskRestorePointOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ComputeManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_disk_restore_point_get(self, resource_group):
        response = self.client.disk_restore_point.get(
            resource_group_name=resource_group.name,
            restore_point_collection_name="str",
            vm_restore_point_name="str",
            disk_restore_point_name="str",
            api_version="2023-10-02",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_disk_restore_point_list_by_restore_point(self, resource_group):
        response = self.client.disk_restore_point.list_by_restore_point(
            resource_group_name=resource_group.name,
            restore_point_collection_name="str",
            vm_restore_point_name="str",
            api_version="2023-10-02",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_disk_restore_point_begin_grant_access(self, resource_group):
        response = self.client.disk_restore_point.begin_grant_access(
            resource_group_name=resource_group.name,
            restore_point_collection_name="str",
            vm_restore_point_name="str",
            disk_restore_point_name="str",
            grant_access_data={
                "access": "str",
                "durationInSeconds": 0,
                "fileFormat": "str",
                "getSecureVMGuestStateSAS": bool,
            },
            api_version="2023-10-02",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_disk_restore_point_begin_revoke_access(self, resource_group):
        response = self.client.disk_restore_point.begin_revoke_access(
            resource_group_name=resource_group.name,
            restore_point_collection_name="str",
            vm_restore_point_name="str",
            disk_restore_point_name="str",
            api_version="2023-10-02",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
