# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.datamigration import DataMigrationManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestDataMigrationManagementServicesOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(DataMigrationManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_services_begin_create_or_update(self, resource_group):
        response = self.client.services.begin_create_or_update(
            group_name="str",
            service_name="str",
            parameters={
                "autoStopDelay": "str",
                "deleteResourcesOnStop": bool,
                "etag": "str",
                "id": "str",
                "kind": "str",
                "location": "str",
                "name": "str",
                "provisioningState": "str",
                "publicKey": "str",
                "sku": {"capacity": 0, "family": "str", "name": "str", "size": "str", "tier": "str"},
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
                "virtualNicId": "str",
                "virtualSubnetId": "str",
            },
            api_version="2025-03-15-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_services_get(self, resource_group):
        response = self.client.services.get(
            group_name="str",
            service_name="str",
            api_version="2025-03-15-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_services_begin_delete(self, resource_group):
        response = self.client.services.begin_delete(
            group_name="str",
            service_name="str",
            api_version="2025-03-15-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_services_begin_update(self, resource_group):
        response = self.client.services.begin_update(
            group_name="str",
            service_name="str",
            parameters={
                "autoStopDelay": "str",
                "deleteResourcesOnStop": bool,
                "etag": "str",
                "id": "str",
                "kind": "str",
                "location": "str",
                "name": "str",
                "provisioningState": "str",
                "publicKey": "str",
                "sku": {"capacity": 0, "family": "str", "name": "str", "size": "str", "tier": "str"},
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
                "virtualNicId": "str",
                "virtualSubnetId": "str",
            },
            api_version="2025-03-15-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_services_check_status(self, resource_group):
        response = self.client.services.check_status(
            group_name="str",
            service_name="str",
            api_version="2025-03-15-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_services_begin_start(self, resource_group):
        response = self.client.services.begin_start(
            group_name="str",
            service_name="str",
            api_version="2025-03-15-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_services_begin_stop(self, resource_group):
        response = self.client.services.begin_stop(
            group_name="str",
            service_name="str",
            api_version="2025-03-15-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_services_list_skus(self, resource_group):
        response = self.client.services.list_skus(
            group_name="str",
            service_name="str",
            api_version="2025-03-15-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_services_check_children_name_availability(self, resource_group):
        response = self.client.services.check_children_name_availability(
            group_name="str",
            service_name="str",
            parameters={"name": "str", "type": "str"},
            api_version="2025-03-15-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_services_list_by_resource_group(self, resource_group):
        response = self.client.services.list_by_resource_group(
            group_name="str",
            api_version="2025-03-15-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_services_list(self, resource_group):
        response = self.client.services.list(
            api_version="2025-03-15-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_services_check_name_availability(self, resource_group):
        response = self.client.services.check_name_availability(
            location="str",
            parameters={"name": "str", "type": "str"},
            api_version="2025-03-15-preview",
        )

        # please add some check logic here by yourself
        # ...
