# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AcceptGrowCapacityPoolForShortTermCloneSplit(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """While auto splitting the short term clone volume, if the parent pool does not have enough space
    to accommodate the volume after split, it will be automatically resized, which will lead to
    increased billing. To accept capacity pool size auto grow and create a short term clone volume,
    set the property as accepted.
    """

    ACCEPTED = "Accepted"
    """Auto grow capacity pool for short term clone split is accepted."""
    DECLINED = "Declined"
    """Auto grow capacity pool for short term clone split is declined. Short term clone volume
    creation will not be allowed, to create short term clone volume accept auto grow capacity pool."""


class ActiveDirectoryStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Status of the Active Directory."""

    CREATED = "Created"
    """Active Directory created but not in use"""
    IN_USE = "InUse"
    """Active Directory in use by SMB Volume"""
    DELETED = "Deleted"
    """Active Directory Deleted"""
    ERROR = "Error"
    """Error with the Active Directory"""
    UPDATING = "Updating"
    """Active Directory Updating"""


class ApplicationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Application Type."""

    SAP_HANA = "SAP-HANA"
    ORACLE = "ORACLE"


class AvsDataStore(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies whether the volume is enabled for Azure VMware Solution (AVS) datastore purpose."""

    ENABLED = "Enabled"
    """avsDataStore is enabled"""
    DISABLED = "Disabled"
    """avsDataStore is disabled"""


class BackupType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of backup Manual or Scheduled."""

    MANUAL = "Manual"
    """Manual backup"""
    SCHEDULED = "Scheduled"
    """Scheduled backup"""


class CheckNameResourceTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Resource type used for verification."""

    MICROSOFT_NET_APP_NET_APP_ACCOUNTS = "Microsoft.NetApp/netAppAccounts"
    MICROSOFT_NET_APP_NET_APP_ACCOUNTS_CAPACITY_POOLS = "Microsoft.NetApp/netAppAccounts/capacityPools"
    MICROSOFT_NET_APP_NET_APP_ACCOUNTS_CAPACITY_POOLS_VOLUMES = "Microsoft.NetApp/netAppAccounts/capacityPools/volumes"
    MICROSOFT_NET_APP_NET_APP_ACCOUNTS_CAPACITY_POOLS_VOLUMES_SNAPSHOTS = (
        "Microsoft.NetApp/netAppAccounts/capacityPools/volumes/snapshots"
    )


class CheckQuotaNameResourceTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Resource type used for verification."""

    MICROSOFT_NET_APP_NET_APP_ACCOUNTS = "Microsoft.NetApp/netAppAccounts"
    MICROSOFT_NET_APP_NET_APP_ACCOUNTS_CAPACITY_POOLS = "Microsoft.NetApp/netAppAccounts/capacityPools"
    MICROSOFT_NET_APP_NET_APP_ACCOUNTS_CAPACITY_POOLS_VOLUMES = "Microsoft.NetApp/netAppAccounts/capacityPools/volumes"
    MICROSOFT_NET_APP_NET_APP_ACCOUNTS_CAPACITY_POOLS_VOLUMES_SNAPSHOTS = (
        "Microsoft.NetApp/netAppAccounts/capacityPools/volumes/snapshots"
    )


class ChownMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """This parameter specifies who is authorized to change the ownership of a file. restricted - Only
    root user can change the ownership of the file. unrestricted - Non-root users can change
    ownership of files that they own.
    """

    RESTRICTED = "Restricted"
    UNRESTRICTED = "Unrestricted"


class CoolAccessRetrievalPolicy(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """coolAccessRetrievalPolicy determines the data retrieval behavior from the cool tier to standard
    storage based on the read pattern for cool access enabled volumes. The possible values for this
    field are:
     Default - Data will be pulled from cool tier to standard storage on random reads. This policy
    is the default.
     OnRead - All client-driven data read is pulled from cool tier to standard storage on both
    sequential and random reads.
     Never - No client-driven data is pulled from cool tier to standard storage.
    """

    DEFAULT = "Default"
    ON_READ = "OnRead"
    NEVER = "Never"


class CoolAccessTieringPolicy(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """coolAccessTieringPolicy determines which cold data blocks are moved to cool tier. The possible
    values for this field are: Auto - Moves cold user data blocks in both the Snapshot copies and
    the active file system to the cool tier tier. This policy is the default. SnapshotOnly - Moves
    user data blocks of the Volume Snapshot copies that are not associated with the active file
    system to the cool tier.
    """

    AUTO = "Auto"
    SNAPSHOT_ONLY = "SnapshotOnly"


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class EnableSubvolumes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Flag indicating whether subvolume operations are enabled on the volume."""

    ENABLED = "Enabled"
    """subvolumes are enabled"""
    DISABLED = "Disabled"
    """subvolumes are not enabled"""


class EncryptionKeySource(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Source of key used to encrypt data in volume. Applicable if NetApp account has
    encryption.keySource = 'Microsoft.KeyVault'. Possible values (case-insensitive) are:
    'Microsoft.NetApp, Microsoft.KeyVault'.
    """

    MICROSOFT_NET_APP = "Microsoft.NetApp"
    """Microsoft-managed key encryption"""
    MICROSOFT_KEY_VAULT = "Microsoft.KeyVault"
    """Customer-managed key encryption"""


class EncryptionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Encryption type of the capacity pool, set encryption type for data at rest for this pool and
    all volumes in it. This value can only be set when creating new pool.
    """

    SINGLE = "Single"
    """EncryptionType Single, volumes will use single encryption at rest"""
    DOUBLE = "Double"
    """EncryptionType Double, volumes will use double encryption at rest"""


class EndpointType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates whether the local volume is the source or destination for the Volume Replication."""

    SRC = "src"
    DST = "dst"


class FileAccessLogs(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Flag indicating whether file access logs are enabled for the volume, based on active diagnostic
    settings present on the volume.
    """

    ENABLED = "Enabled"
    """fileAccessLogs are enabled"""
    DISABLED = "Disabled"
    """fileAccessLogs are not enabled"""


class InAvailabilityReasonType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """:code:`<code>Invalid</code>` indicates the name provided does not match Azure App Service
    naming requirements. :code:`<code>AlreadyExists</code>` indicates that the name is already in
    use and is therefore unavailable.
    """

    INVALID = "Invalid"
    ALREADY_EXISTS = "AlreadyExists"


class KeySource(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The encryption keySource (provider). Possible values (case-insensitive):  Microsoft.NetApp,
    Microsoft.KeyVault.
    """

    MICROSOFT_NET_APP = "Microsoft.NetApp"
    """Microsoft-managed key encryption"""
    MICROSOFT_KEY_VAULT = "Microsoft.KeyVault"
    """Customer-managed key encryption"""


class KeyVaultStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Status of the KeyVault connection."""

    CREATED = "Created"
    """KeyVault connection created but not in use"""
    IN_USE = "InUse"
    """KeyVault connection in use by SMB Volume"""
    DELETED = "Deleted"
    """KeyVault connection Deleted"""
    ERROR = "Error"
    """Error with the KeyVault connection"""
    UPDATING = "Updating"
    """KeyVault connection Updating"""


class ManagedServiceIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of managed service identity (where both SystemAssigned and UserAssigned types are
    allowed).
    """

    NONE = "None"
    SYSTEM_ASSIGNED = "SystemAssigned"
    USER_ASSIGNED = "UserAssigned"
    SYSTEM_ASSIGNED_USER_ASSIGNED = "SystemAssigned,UserAssigned"


class MetricAggregationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """MetricAggregationType."""

    AVERAGE = "Average"


class MirrorState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of the replication."""

    UNINITIALIZED = "Uninitialized"
    MIRRORED = "Mirrored"
    BROKEN = "Broken"


class MultiAdStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """MultiAD Status for the account."""

    DISABLED = "Disabled"
    """Account is MultiAD disabled, Means its a SharedAD or SingleAD account."""
    ENABLED = "Enabled"
    """Account is MultiAD enabled"""


class NetworkFeatures(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Network features available to the volume, or current state of update."""

    BASIC = "Basic"
    """Basic network features."""
    STANDARD = "Standard"
    """Standard network features."""
    BASIC_STANDARD = "Basic_Standard"
    """Updating from Basic to Standard network features."""
    STANDARD_BASIC = "Standard_Basic"
    """Updating from Standard to Basic network features."""


class NetworkSiblingSetProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Gets the status of the NetworkSiblingSet at the time the operation was called."""

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"
    UPDATING = "Updating"


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Gets the status of the VolumeQuotaRule at the time the operation was called."""

    ACCEPTED = "Accepted"
    CREATING = "Creating"
    PATCHING = "Patching"
    DELETING = "Deleting"
    MOVING = "Moving"
    FAILED = "Failed"
    SUCCEEDED = "Succeeded"


class QosType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The qos type of the pool."""

    AUTO = "Auto"
    """qos type Auto"""
    MANUAL = "Manual"
    """qos type Manual"""


class RegionStorageToNetworkProximity(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Provides storage to network proximity information in the region."""

    DEFAULT = "Default"
    """Basic network connectivity."""
    T1 = "T1"
    """Standard T1 network connectivity."""
    T2 = "T2"
    """Standard T2 network connectivity."""
    ACROSS_T2 = "AcrossT2"
    """Standard AcrossT2 network connectivity."""
    T1_AND_T2 = "T1AndT2"
    """Standard T1 and T2 network connectivity."""
    T1_AND_ACROSS_T2 = "T1AndAcrossT2"
    """Standard T1 and AcrossT2 network connectivity."""
    T2_AND_ACROSS_T2 = "T2AndAcrossT2"
    """Standard T2 and AcrossT2 network connectivity."""
    T1_AND_T2_AND_ACROSS_T2 = "T1AndT2AndAcrossT2"
    """Standard T1, T2 and AcrossT2 network connectivity."""


class RelationshipStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Status of the mirror relationship."""

    IDLE = "Idle"
    TRANSFERRING = "Transferring"
    FAILED = "Failed"
    UNKNOWN = "Unknown"


class ReplicationSchedule(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Schedule."""

    _10_MINUTELY = "_10minutely"
    HOURLY = "hourly"
    DAILY = "daily"


class ReplicationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates whether the replication is cross zone or cross region."""

    CROSS_REGION_REPLICATION = "CrossRegionReplication"
    """Cross region replication"""
    CROSS_ZONE_REPLICATION = "CrossZoneReplication"
    """Cross zone replication"""


class SecurityStyle(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The security style of volume, default unix, defaults to ntfs for dual protocol or CIFS
    protocol.
    """

    NTFS = "ntfs"
    UNIX = "unix"


class ServiceLevel(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The service level of the file system."""

    STANDARD = "Standard"
    """Standard service level"""
    PREMIUM = "Premium"
    """Premium service level"""
    ULTRA = "Ultra"
    """Ultra service level"""
    STANDARD_ZRS = "StandardZRS"
    """Zone redundant storage service level. This will be deprecated soon."""
    FLEXIBLE = "Flexible"
    """Flexible service level"""


class SmbAccessBasedEnumeration(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enables access-based enumeration share property for SMB Shares. Only applicable for
    SMB/DualProtocol volume.
    """

    DISABLED = "Disabled"
    """smbAccessBasedEnumeration share setting is disabled"""
    ENABLED = "Enabled"
    """smbAccessBasedEnumeration share setting is enabled"""


class SmbNonBrowsable(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enables non-browsable property for SMB Shares. Only applicable for SMB/DualProtocol volume."""

    DISABLED = "Disabled"
    """smbNonBrowsable share setting is disabled"""
    ENABLED = "Enabled"
    """smbNonBrowsable share setting is enabled"""


class Type(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of quota."""

    DEFAULT_USER_QUOTA = "DefaultUserQuota"
    """Default user quota"""
    DEFAULT_GROUP_QUOTA = "DefaultGroupQuota"
    """Default group quota"""
    INDIVIDUAL_USER_QUOTA = "IndividualUserQuota"
    """Individual user quota"""
    INDIVIDUAL_GROUP_QUOTA = "IndividualGroupQuota"
    """Individual group quota"""


class VolumeStorageToNetworkProximity(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Provides storage to network proximity information for the volume."""

    DEFAULT = "Default"
    """Basic storage to network connectivity."""
    T1 = "T1"
    """Standard T1 storage to network connectivity."""
    T2 = "T2"
    """Standard T2 storage to network connectivity."""
    ACROSS_T2 = "AcrossT2"
    """Standard AcrossT2 storage to network connectivity."""
