# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.containerservice.aio import ContainerServiceClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestContainerServiceManagedNamespacesOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ContainerServiceClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_managed_namespaces_list_by_managed_cluster(self, resource_group):
        response = self.client.managed_namespaces.list_by_managed_cluster(
            resource_group_name=resource_group.name,
            resource_name="str",
            api_version="2025-09-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_managed_namespaces_get(self, resource_group):
        response = await self.client.managed_namespaces.get(
            resource_group_name=resource_group.name,
            resource_name="str",
            managed_namespace_name="str",
            api_version="2025-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_managed_namespaces_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.managed_namespaces.begin_create_or_update(
                resource_group_name=resource_group.name,
                resource_name="str",
                managed_namespace_name="str",
                parameters={
                    "eTag": "str",
                    "id": "str",
                    "location": "str",
                    "name": "str",
                    "properties": {
                        "adoptionPolicy": "str",
                        "annotations": {"str": "str"},
                        "defaultNetworkPolicy": {"egress": "str", "ingress": "str"},
                        "defaultResourceQuota": {
                            "cpuLimit": "str",
                            "cpuRequest": "str",
                            "memoryLimit": "str",
                            "memoryRequest": "str",
                        },
                        "deletePolicy": "str",
                        "labels": {"str": "str"},
                        "portalFqdn": "str",
                        "provisioningState": "str",
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "type": "str",
                },
                api_version="2025-09-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_managed_namespaces_begin_delete(self, resource_group):
        response = await (
            await self.client.managed_namespaces.begin_delete(
                resource_group_name=resource_group.name,
                resource_name="str",
                managed_namespace_name="str",
                api_version="2025-09-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_managed_namespaces_update(self, resource_group):
        response = await self.client.managed_namespaces.update(
            resource_group_name=resource_group.name,
            resource_name="str",
            managed_namespace_name="str",
            parameters={"tags": {"str": "str"}},
            api_version="2025-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_managed_namespaces_list_credential(self, resource_group):
        response = await self.client.managed_namespaces.list_credential(
            resource_group_name=resource_group.name,
            resource_name="str",
            managed_namespace_name="str",
            api_version="2025-09-01",
        )

        # please add some check logic here by yourself
        # ...
